/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: AsiMaster_Functionlist.h $
   Last Modification:
    $Id: AsiMaster_Functionlist.h 2476 2009-07-20 14:33:48Z AndreasB $

    $Author: Eric $
    $Modtime: 31.10.07 8:21 $
    $Revision: 0 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    AS-Interface Master
    Task function list for configuration file

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
    1           21.01.09    ES
        Created

**************************************************************************************/
/**
 * @file AsiMaster_Functionlist.h
 * @brief AS-Interface - function list
 *
 * The header has to be included in the configuration source file of firmware.
 * Use the content of header file to configure the startup parameter of tasks
 * and to define the entry point <code>TaskEnter_AsiMaster</code>
 * of task.
 */
#ifndef __ASI_MASTER_FUNCTIONLIST_H
#define __ASI_MASTER_FUNCTIONLIST_H


/*************************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 */

TLR_RESULT
TaskExit_AsiMaster
(
 TLR_VOID FAR* pvRsc
);

TLR_RESULT
TaskLeave_AsiMaster
(
 TLR_VOID FAR* pvRsc,
 TLR_VOID FAR* pvLve
);

TLR_VOID
TaskEnter_AsiMaster
(
 TLR_VOID FAR* pvInit
);

/** @} */


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define ASI_MASTER_STARTUP_PARAM_VERSION_1 (1)


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** task startup parameter */
typedef struct ASI_MASTER_STARTUPPARAMETER_Ttag  ASI_MASTER_STARTUPPARAMETER_T;

#define ASI_MASTER_MIN_CYCLETIME  1
#define ASI_MASTER_MAX_CYCLETIME  10

#define ASI_MASTER_MIN_ASI_CYCLE_TIME_MIN     0
#define ASI_MASTER_MIN_ASI_CYCLE_TIME_MAX     450000

#define ASI_MASTER_MANAGEMENT_PHASE_REQUIRED  0
#define ASI_MASTER_MANAGEMENT_PHASE_ALWAYS    1

#define ASI_MASTER_XC_INST_0      0
#define ASI_MASTER_XC_INST_1      1
#define ASI_MASTER_XC_INST_2      2
#define ASI_MASTER_XC_INST_3      3

/*Default  names*/
#define ASI_MASTER_XC_XPEC_NAME     "ASIM_XPEC"
#define ASI_MASTER_XC_XMACRPU_NAME  "ASIM_XMACRPU"
#define ASI_MASTER_XC_XMACTPU_NAME  "ASIM_XMACTPU"
#define ASI_MASTER_FIFO_NAME        "ASIM_FIFO_CHN"
#define ASI_MASTER_XC_COM_IRQ_NAME  "ASIM_COM"

#define ASI_MASTER_QUEUE_MIN_ELEM    8
#define ASI_MASTER_QUEUE_DEF_ELEM   32
#define ASI_MASTER_QUEUE_MAX_ELEM   64

#define ASI_MASTER_POOL_MIN_ELEM     8
#define ASI_MASTER_POOL_DEF_ELEM    32
#define ASI_MASTER_POOL_MAX_ELEM    64

/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct ASI_MASTER_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  TLR_TASK_PARAMETERHEADER;
  /** Task Cycle Time */
  TLR_UINT32  ulCycleTime;
  /** ASi Cycle Time*/
  TLR_UINT32  ulMinAsiCycleTime;
  TLR_UINT32  ulDummyRead;
  /** XC Instance */
  TLR_UINT32  ulXcInst;
  STRING      szComIrqName[16];
  STRING      szXpecName[16];
  STRING      szXmacRpuName[16];
  STRING      szXmacTpuName[16];
  STRING      szFifoName[16];
  /** Queue element count*/
  TLR_UINT32 ulQueueElem;
  /** Pool element count*/
  TLR_UINT32 ulPoolElem;
};

/** @} */


/*************************************************************************************/
#endif /* #ifndef __ASI_MASTER_FUNCTIONLIST_H */

/*************************************************************************************/
/*-----------------------------------------------------------------------------------*/
/*-------------------------- EOF ----------------------------------------------------*/
/*-----------------------------------------------------------------------------------*/
/*************************************************************************************/
